// 2023 NikDorn.com
/*
 * License:
 * This code is provided under the terms of the MIT License.
 * You may use, modify, and distribute this code for any purpose,
 * both commercial and non-commercial, as long as the original
 * copyright notice and the license terms are included.
 *
 * Warranty:
 * This code is provided as-is, without any warranty or guarantees.
 * You are solely responsible for any consequences of using this code.
 * By using this code, you agree to the terms and conditions of use.
 */

var doc = app.activeDocument;
var layers = doc.layers;
var story = 0;


var snapshot = doc.activeHistoryState;


var visibilityStates = [];
for (var i = 0; i < layers.length; i++) {
  visibilityStates[i] = layers[i].visible;
  layers[i].visible = false;
}

for (var i = 0; i < layers.length; i++) {
  var layer = app.activeDocument.layers[i];

  if (layer.name.substr(-6).toLowerCase() == "_unity") {
    layer.visible = true;
    var bounds = layer.bounds;
    var imgWidth = bounds[2].value - bounds[0].value;
    var imgHeight = bounds[3].value - bounds[1].value;
    var newWidth = Math.ceil(imgWidth / 4) * 4;
    var newHeight = Math.ceil(imgHeight / 4) * 4;

    doc.resizeCanvas(newWidth, newHeight);
    layer.translate(-layer.bounds[0].as('px'), -layer.bounds[1].as('px'));
    var file = new File(doc.path + "/" + layer.name + ".png");
    var opts = new ExportOptionsSaveForWeb();
    opts.format = SaveDocumentType.PNG;
    opts.PNG8 = false;
    doc.exportDocument(file, ExportType.SAVEFORWEB, opts);
    layer.visible = false;
    story = i;
  } else {
    layer.visible = false;
  }
}

doc.activeHistoryState = snapshot;

for (var i = 0; i < layers.length; i++) {
  layers[i].visible = visibilityStates[i];
}

alert("PNG layers exported successfully!");